implementation module oswindow


import	StdInt, StdReal, StdClass, StdOverloaded, StdList
import	clCrossCall, intrface
import	osfont, ospicture, osrgn, ossystem, ostypes
from	commondef		import Error,IntersectRects
//import trace,tracetypes

oswindowError :: String String -> .x
oswindowError function error
	= Error function "oswindow" error


OSGetProcessWindowDimensions :: !*OSToolbox -> (!Rect,!*OSToolbox)
OSGetProcessWindowDimensions tb
	= ((0,0, 0,0), tb)

::	OSWindowPtr
	:==	HWND
OSNoWindowPtr
	:== -1


/*	System dependent constants:
*/
OSControlTitleSpecialChars
	:== []											// Special prefix characters that should be removed


/*	System dependent metrics:
*/
::	OSWindowMetrics
	=	{	osmFont				:: Font				// The internal Font used in Windows for controls
		,	osmFontMetrics		:: (Int,Int,Int)	// The ascent, descent, leading of osmFont
		,	osmHeight			:: Int				// The height of the internal Font
		,	osmHorMargin		:: Int				// The default horizontal margin
		,	osmVerMargin		:: Int				// The default vertical   margin
		,	osmHorItemSpace		:: Int				// The default horizontal item space
		,	osmVerItemSpace		:: Int				// The default vertical   item space
		,	osmHSliderHeight	:: Int				// The default height of a horizontal slider control
		,	osmVSliderWidth		:: Int				// The default width  of a vertical   slider control
		}

OSDefaultWindowMetrics :: !*OSToolbox -> (!OSWindowMetrics,!*OSToolbox)
OSDefaultWindowMetrics tb
	# (font,tb)							= OSdialogfont tb
	# ((ascent,descent,leading,_),tb)	= OSgetfontmetrics False 0 font tb
	  height							= ascent+descent+leading
	  unit								= (toReal height)/8.0
	  margin							= toInt (unit*7.0)
	  itemspace							= toInt (unit*4.0)
	# (scrollWidth,scrollHeight,tb)		= WinScrollbarSize tb
	= (	{	osmFont				= font
		,	osmFontMetrics		= (ascent,descent,leading)
		,	osmHeight			= height
		,	osmHorMargin		= margin
		,	osmVerMargin		= margin
		,	osmHorItemSpace		= itemspace
		,	osmVerItemSpace		= itemspace
		,	osmHSliderHeight	= scrollHeight
		,	osmVSliderWidth		= scrollWidth
		}
	  ,	tb
	  )

OSMinWindowSize :: (!Int,!Int)
OSMinWindowSize = WinMinimumWinSize

OSMinCompoundSize :: (!Int,!Int)
OSMinCompoundSize = WinMinimumWinSize


/*	Determine the size of controls.
*/
OSgetButtonControlSize :: !OSWindowMetrics !String !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetButtonControlSize {osmFont,osmHeight} text tb
	# (widths,tb)	= OSgetfontstringwidths False 0 [text] osmFont tb
	  width			= hd widths
	= ((2*osmHeight+width,2*osmHeight),tb)

OSgetTextControlSize :: !OSWindowMetrics !String !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetTextControlSize {osmFont,osmHeight} text tb
	# (widths,tb)	= OSgetfontstringwidths False 0 [text] osmFont tb
	  width			= hd widths
	= ((width+osmHeight/4,osmHeight+osmHeight/2),tb)

OSgetEditControlSize :: !OSWindowMetrics !Int !Int !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetEditControlSize {osmHeight} width nrlines tb
	= ((width,toInt (1.5*toReal (osmHeight*nrlines))),tb)

OSgetPopUpControlSize :: !OSWindowMetrics ![String] !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetPopUpControlSize {osmFont,osmHeight} items tb
	# (widths,tb)	= OSgetfontstringwidths False 0 items osmFont tb
	  maxwidth		= listmax widths
	= ((maxwidth+2*osmHeight+osmHeight/2,osmHeight+osmHeight/2+5),tb)
where
	listmax :: ![Int] -> Int
	listmax [x:xs]	= foldr max x xs
	listmax _		= 0

OSgetRadioControlItemSize :: !OSWindowMetrics !String !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetRadioControlItemSize wMetrics=:{osmFont,osmHeight} text tb
	# (widths,tb)	= OSgetfontstringwidths False 0 [text] osmFont tb
	  width			= hd widths
	= ((width+2*osmHeight+osmHeight/2,OSgetRadioControlItemHeight wMetrics),tb)

OSgetRadioControlItemHeight :: !OSWindowMetrics -> Int
OSgetRadioControlItemHeight {osmHeight}
	= osmHeight+osmHeight/2

OSgetCheckControlItemSize :: !OSWindowMetrics !String !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetCheckControlItemSize wMetrics=:{osmFont,osmHeight} text tb
	# (widths,tb)	= OSgetfontstringwidths False 0 [text] osmFont tb
	  width			= hd widths
	= ((width+2*osmHeight+osmHeight/2,OSgetCheckControlItemHeight wMetrics),tb)

OSgetCheckControlItemHeight :: !OSWindowMetrics -> Int
OSgetCheckControlItemHeight {osmHeight}
	= osmHeight+osmHeight/2

OSgetSliderControlSize :: !OSWindowMetrics !Bool !Int -> (!Int,!Int)
OSgetSliderControlSize wMetrics isHorizontal length
	| isHorizontal
	= (length,wMetrics.osmHSliderHeight)
	= (wMetrics.osmVSliderWidth,length)


/*	Window creation functions.
*/
::	DelayActivationInfo						// ActivationInfo states whether the window
	=	DelayActivated		OSWindowPtr		// has become active or
	|	DelayDeactivated	OSWindowPtr		// has become inactive

OScreateDialog :: !Bool !Bool !String !(!Int,!Int) !(!Int,!Int)
				  !(.s->(OSWindowPtr,.s))
				  !(OSWindowPtr->.s->*OSToolbox->(.s,*OSToolbox))
				  !(OSWindowPtr->OSWindowPtr->OSPictContext->.s->*OSToolbox->(.s,*OSToolbox))
				  !.s !*OSToolbox
			   -> (![DelayActivationInfo],!OSWindowPtr,!.s,!*OSToolbox)
OScreateDialog isModal isClosable title pos size get_focus create_controls update_controls control_info tb
	# (textPtr,tb)	= WinMakeCString title tb
	  createcci		= {ccMsg=CcRqCREATEDIALOG,p1=textPtr,p2=0,p3=0,p4=0,p5=0,p6=toInt isModal}
	# (returncci,(control_info,delay_info),tb)
					= IssueCleanRequest (OScreateDialogCallback get_focus create_controls update_controls)
										createcci
										(control_info,[]) tb
	# tb			= WinReleaseCString textPtr tb
	  wPtr			= case returncci.ccMsg of
	  					CcRETURN1	-> returncci.p1
	  					CcWASQUIT	-> OSNoWindowPtr
	  					_			-> oswindowCreateError "OScreateDialog"
	= (reverse delay_info,wPtr,control_info,tb)
where
	OScreateDialogCallback :: !(.s->(OSWindowPtr,.s))
							  !(OSWindowPtr->.s->*OSToolbox->(.s,*OSToolbox))
							  !(OSWindowPtr->OSWindowPtr->OSPictContext->.s->*OSToolbox->(.s,*OSToolbox))
							  !CrossCallInfo !(.s,[DelayActivationInfo]) !*OSToolbox
						  -> (!CrossCallInfo,!(.s,[DelayActivationInfo]),!*OSToolbox)
	OScreateDialogCallback _ _ _ {ccMsg=CcWmPAINT,p1=hwnd} s tb
		= //trace "OScreateDialogCallback CcWmPAINT" 
		  (Return0Cci, s, OSdelayWindowUpdate hwnd tb)
	OScreateDialogCallback _ _ _ {ccMsg=CcWmGETMINMAXINFO,p1=hwnd} s tb
		= //trace "OScreateDialogCallback CcWmGETMINMAXINFO" 
		  (Return0Cci, s, tb)
	OScreateDialogCallback _ _ _ {ccMsg=CcWmACTIVATE,p1=hwnd} (control_info,delay_info) tb
		= //trace "OScreateDialogCallback CcWmACTIVATE" 
		  (Return0Cci, (control_info,[DelayActivated hwnd:delay_info]), tb)
	OScreateDialogCallback _ _ _ {ccMsg=CcWmDEACTIVATE,p1=hwnd} (control_info,delay_info) tb
		= //trace "OScreateDialogCallback CcWmDEACTIVATE" 
		  (Return0Cci, (control_info,[DelayDeactivated hwnd:delay_info]), tb)
	OScreateDialogCallback get_focus create_controls _ {ccMsg=CcWmINITDIALOG,p1=hwnd} (control_info,delay_info) tb
		# (control_info,tb)			= create_controls hwnd control_info tb
		# (defhandle,control_info)	= get_focus control_info
		  (x,y)						= pos
		  (w,h)						= size
		  r5cci						= Return5Cci x y w h defhandle
		= (r5cci, (control_info,delay_info), tb)
	OScreateDialogCallback _ _ update_controls {ccMsg=CcWmDRAWCONTROL,p1=hdlog,p2=hctrl,p3=hdc} (control_info,delay_info) tb
		# (control_info,tb)			= update_controls hdlog hctrl hdc control_info tb
		= (Return0Cci, (control_info,delay_info), tb)
	OScreateDialogCallback _ _ _ {ccMsg} s tb
		= oswindowError "OScreateDialogCallback" ("Fatal error: unknown message type ("+++toString ccMsg+++")")

OScreateWindow :: !Bool !ScrollbarInfo !ScrollbarInfo !(!Int,!Int) !(!Int,!Int)
				  !Bool !String !(!Int,!Int) !(!Int,!Int)
				  !(.s->(OSWindowPtr,.s))
				  !(OSWindowPtr->.s->*OSToolbox->(.s,*OSToolbox))
				  !(OSWindowPtr->OSWindowPtr->OSPictContext->.s->*OSToolbox->(.s,*OSToolbox))
				  !.s !*OSToolbox
			   -> (![DelayActivationInfo],!OSWindowPtr,!OSWindowPtr,!OSWindowPtr,!.s,!*OSToolbox)
OScreateWindow	isResizable
				hInfo=:{cbiHasScroll=hasHScroll}
				vInfo=:{cbiHasScroll=hasVScroll}
				minSize maxSize
				isClosable title pos size get_focus create_controls update_controls control_info tb
	# (textPtr,tb)	= WinMakeCString title tb
	  styleFlags	= WS_SYSMENU
	  					bitor WS_OVERLAPPED
	  					bitor (if hasHScroll  WS_HSCROLL    0)
	  					bitor (if hasVScroll  WS_VSCROLL    0)
	  					bitor (if isResizable WS_THICKFRAME 0)
	  		//			bitor WS_CLIPCHILDREN
	  createcci		= {ccMsg=CcRqCREATEWINDOW,p1=textPtr,p2=x,p3=y,p4=w,p5=h,p6=styleFlags}
	# (returncci,(control_info,delay_info),tb)
					= IssueCleanRequest (OScreateWindowCallback create_controls update_controls)
										createcci
										(control_info,[]) tb
	# tb			= WinReleaseCString textPtr tb
	  wPtr			= case returncci.ccMsg of
	  					CcRETURN1	-> returncci.p1
	  					CcWASQUIT	-> OSNoWindowPtr
	  					_			-> oswindowCreateError "OScreateWindow"
	# tb			= setScrollRangeAndPos hasHScroll SB_HORZ hInfo.cbiState wPtr tb
	# tb			= setScrollRangeAndPos hasVScroll SB_VERT vInfo.cbiState wPtr tb
	= (reverse delay_info,wPtr,OSNoWindowPtr,OSNoWindowPtr,control_info,tb)
where
	(x,y)			= pos
	(w,h)			= size
	(maxw,maxh)		= maxSize
	(minw,minh)		= minSize
	
	OScreateWindowCallback :: !(OSWindowPtr->.s->*OSToolbox->(.s,*OSToolbox))
							  !(OSWindowPtr->OSWindowPtr->OSPictContext->.s->*OSToolbox->(.s,*OSToolbox))
							  !CrossCallInfo !(.s,[DelayActivationInfo]) !*OSToolbox
						  -> (!CrossCallInfo,!(.s,[DelayActivationInfo]),!*OSToolbox)
	OScreateWindowCallback _ _ {ccMsg=CcWmPAINT,p1=hwnd} s tb
		= //trace "OScreateWindowCallback CcWmPAINT" 
		  (Return0Cci, s, OSdummyWindowUpdate hwnd tb)
	where
		OSdummyWindowUpdate :: !OSWindowPtr !*OSToolbox -> *OSToolbox
		OSdummyWindowUpdate wPtr tb
			# (hdc,tb) = WinBeginPaint wPtr tb
			= WinEndPaint wPtr (hdc,tb)
	OScreateWindowCallback _ _ {ccMsg=CcWmGETMINMAXINFO} s tb
		| isResizable
		= //trace ("OScreateWindowCallback CcWmGETMINMAXINFO-->"+++toString (maxw,maxh,minw,minh))
				(Return4Cci maxw maxh minw minh, s, tb)
		= //trace "OScreateWindowCallback CcWmGETMINMAXINFO-->()" 
		  (Return0Cci,s,tb)
	OScreateWindowCallback _ _ {ccMsg=CcWmACTIVATE,p1=hwnd} (control_info,delay_info) tb
		= //trace "OScreateWindowCallback CcWmACTIVATE" 
		  (Return0Cci, (control_info,[DelayActivated hwnd:delay_info]), tb)
	OScreateWindowCallback _ _ {ccMsg=CcWmDEACTIVATE,p1=hwnd} (control_info,delay_info) tb
		= //trace "OScreateWindowCallback CcWmDEACTIVATE" 
		  (Return0Cci, (control_info,[DelayDeactivated hwnd:delay_info]), tb)
	OScreateWindowCallback create_controls _ {ccMsg=CcWmCREATE,p1=hwnd} (control_info,deactivates) tb
		# (control_info,tb)			= create_controls hwnd control_info tb
		= (Return0Cci, (control_info,deactivates), tb)
	OScreateWindowCallback _ _ {ccMsg=CcWmNEWHTHUMB,p1=hwnd,p2=thumb} s tb
		= //trace "OScreateWindowCallback CcWmNEWHTHUMB" 
		  (Return0Cci, s, tb)
	OScreateWindowCallback _ _ {ccMsg=CcWmNEWVTHUMB,p1=hwnd,p2=thumb} s tb
		= //trace "OScreateWindowCallback CcWmNEWVTHUMB" 
		  (Return0Cci, s, tb)
	OScreateWindowCallback _ _ {ccMsg=CcWmSIZE,p1=hwnd,p2=width,p3=height} s tb
		= //trace ("OScreateWindowCallback CcWmSize "+++toString (width,height)) 
		  (Return0Cci, s, tb)
	OScreateWindowCallback _ _ {ccMsg} s tb
		= oswindowError "OScreateWindowCallback" ("Fatal error: unknown message type ("+++toString ccMsg+++")")

OSdelayWindowUpdate :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdelayWindowUpdate wPtr tb
	# (hdc,tb)	= WinBeginPaint wPtr tb
	# tb		= WinEndPaint wPtr (hdc,tb)
	= WinInvalidateWindow wPtr tb


/*	Control creation functions.
*/
oswindowCreateError :: String -> .x
oswindowCreateError function
	= abort ("Fatal error: "+++function+++" expected CcRETURN1 value.\n")

osIgnoreCallback :: !CrossCallInfo !*OSToolbox -> (!CrossCallInfo,!*OSToolbox)
osIgnoreCallback {ccMsg=CcWmPAINT,p1=hwnd} tb
	= (Return0Cci,WinEndPaint hwnd (WinBeginPaint hwnd tb))
osIgnoreCallback _ tb 
	= (Return0Cci,tb)

//	PA: hiding not implemented (maybe not necessary)!!
OScreateRadioControl :: !OSWindowPtr !(!Int,!Int) !String !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Bool !Bool !*OSToolbox
																						   -> (!OSWindowPtr,!*OSToolbox)
OScreateRadioControl parentWindow parentPos title show able (x,y) (w,h) selected isfirst tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	  createcci		= {ccMsg=CcRqCREATERADIOBUT,p1=parentWindow,p2=x,p3=y,p4=w,p5=h,p6=toInt isfirst}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  radioPtr		= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateRadioControl"
	# tb			= WinSetWindowTitle radioPtr title tb
	# tb			= WinCheckControl   radioPtr selected tb
	# tb			= WinEnableControl  radioPtr able tb
	= (radioPtr,tb)

//	PA: hiding not implemented (maybe not necessary)!!
OScreateCheckControl :: !OSWindowPtr !(!Int,!Int) !String !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Bool !Bool !*OSToolbox
																						   -> (!OSWindowPtr,!*OSToolbox)
OScreateCheckControl parentWindow parentPos title show able (x,y) (w,h) selected isfirst tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	  createcci		= {ccMsg=CcRqCREATECHECKBOX,p1=parentWindow,p2=x,p3=y,p4=w,p5=h,p6=toInt isfirst}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  checkPtr		= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateCheckControl"
	# tb			= WinSetWindowTitle checkPtr title tb
	# tb			= WinCheckControl   checkPtr selected tb
	# tb			= WinEnableControl  checkPtr able tb
	= (checkPtr,tb)

MaxComboboxWidth		:== 65535		// System maximum for width  of combo box
MaxComboboxHeight		:==	65535		// System maximum for height of combo box
MaxComboElementsVisible	:==	15			// If there are <=MaxComboElementsVisible then show all elements
MaxComboElementsScroll	:==	12			// otherwise, show MaxComboElementsScroll elements

OScreateEmptyPopUpControl :: !OSWindowPtr !(!Int,!Int) !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Int !*OSToolbox -> (!OSWindowPtr,!*OSToolbox)
OScreateEmptyPopUpControl parentWindow parentPos show able (x,y) (w,h) nrItems tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	# ((l,t,r,b),tb)= OSscreenrect tb
	# (wMetrics,tb)	= OSDefaultWindowMetrics tb
	  screenw		= r-l
	  screenh		= b-t
	  height		= wMetrics.osmHeight
	  okNrItems		= if (nrItems<=MaxComboElementsVisible) nrItems MaxComboElementsScroll
	  overall_h		= min screenh (min MaxComboboxHeight (h + okNrItems*(height+2)))
	  overall_w		= min screenw (min MaxComboboxWidth w)
	  createcci		= {ccMsg=CcRqCREATEPOPUP,p1=parentWindow,p2=x,p3=y,p4=overall_w,p5=overall_h,p6=0}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  popUpPtr		= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateEmptyPopUpControl"
	# tb			= WinEnableControl popUpPtr able tb
	= (popUpPtr,tb)

OScreatePopUpControlItem :: !OSWindowPtr !Bool !String !Bool !*OSToolbox -> (!Int,!*OSToolbox)
OScreatePopUpControlItem parentPopUp able title selected tb
	# (textPtr,tb)	= WinMakeCString title tb
	  addcci		= {ccMsg=CcRqADDTOPOPUP,p1=parentPopUp,p2=textPtr,p3=toInt able,p4=toInt selected,p5=0,p6=0}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback addcci tb
	# tb			= WinReleaseCString textPtr tb
	  index			= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> 0
						_			-> oswindowCreateError "OScreatePopUpControlItem"
	= (index,tb)

OScreateSliderControl :: !OSWindowPtr !(!Int,!Int) !Bool !Bool !Bool !(!Int,!Int) !(!Int,!Int) !(!Int,!Int,!Int,!Int) !*OSToolbox
																									 -> (!OSWindowPtr,!*OSToolbox)
OScreateSliderControl parentWindow parentPos show able horizontal (x,y) (w,h) (min,thumb,max,thumbSize) tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	  createcci		= {ccMsg=CcRqCREATESCROLLBAR,p1=parentWindow,p2=x,p3=y,p4=w,p5=h,p6=toInt horizontal}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  sliderPtr		= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateSliderControl"
	# tb			= WinSetScrollRange sliderPtr SB_CTL min max False tb
	# tb			= WinSetScrollPos   sliderPtr SB_CTL thumb True tb
	# tb			= WinEnableControl  sliderPtr able tb
	= (sliderPtr,tb)

OScreateTextControl :: !OSWindowPtr !(!Int,!Int) !String !Bool !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSWindowPtr,!*OSToolbox)
OScreateTextControl parentWindow parentPos text show (x,y) (w,h) tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	  createcci		= {ccMsg=CcRqCREATESTATICTXT,p1=parentWindow,p2=x,p3=y,p4=w,p5=h,p6=0}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  textPtr		= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateTextControl"
	# tb			= WinSetWindowTitle textPtr text tb
	= (textPtr,tb)

OScreateEditControl :: !OSWindowPtr !(!Int,!Int) !String !Bool !Bool !Bool !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSWindowPtr,!*OSToolbox)
OScreateEditControl parentWindow parentPos text show able isKeySensitive (x,y) (w,h) tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	# (wMetrics,tb)	= OSDefaultWindowMetrics tb
	  nrLines		= toInt ((toReal h) / (1.5*(toReal wMetrics.osmHeight)))
	  isMultiLine	= nrLines>1
	  editflags		= (if isMultiLine EDITISMULTILINE 0) + (if isKeySensitive EDITISKEYSENSITIVE 0)
	  createcci		= {ccMsg=CcRqCREATEEDITTXT,p1=parentWindow,p2=x,p3=y,p4=w,p5=h,p6=editflags}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  editPtr		= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateEditControl"
	# tb			= WinSetWindowTitle editPtr text tb
	# tb			= WinEnableControl editPtr able tb
	= (editPtr,tb)

OScreateButtonControl :: !OSWindowPtr !(!Int,!Int) !String !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Bool !*OSToolbox -> (!OSWindowPtr,!*OSToolbox)
OScreateButtonControl parentWindow parentPos title show able (x,y) (w,h) isDefaultButton tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	  createcci		= {ccMsg=CcRqCREATEBUTTON,p1=parentWindow,p2=x,p3=y,p4=w,p5=h,p6=toInt isDefaultButton}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  buttonPtr		= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateButtonControl"
	# tb			= WinSetWindowTitle buttonPtr title tb
	# tb			= WinEnableControl  buttonPtr able tb
	= (buttonPtr,tb)

OScreateCustomButtonControl :: !OSWindowPtr !(!Int,!Int) !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Bool !*OSToolbox -> (!OSWindowPtr,!*OSToolbox)
OScreateCustomButtonControl parentWindow parentPos show able (x,y) (w,h) isDefaultButton tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	  createcci		= {ccMsg=CcRqCREATEICONBUT,p1=parentWindow,p2=x,p3=y,p4=w,p5=h,p6=0}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  buttonPtr		= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateCustomButtonControl"
	# tb			= WinEnableControl buttonPtr able tb
	= (buttonPtr,tb)

OScreateCustomControl :: !OSWindowPtr !(!Int,!Int) !Bool !Bool !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSWindowPtr,!*OSToolbox)
OScreateCustomControl parentWindow parentPos show able (x,y) (w,h) tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	  createcci		= {ccMsg=CcRqCREATECUSTOM,p1=parentWindow,p2=x,p3=y,p4=w,p5=h,p6=0}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  customPtr		= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateCustomControl"
	# tb			= WinEnableControl customPtr able tb
	= (customPtr,tb)

::	ScrollbarInfo
	=	{	cbiHasScroll	:: !Bool				// The scrollbar exists
		,	cbiPos			:: (Int,Int)			// Its position within the parent
		,	cbiSize			:: (Int,Int)			// Its size within the parent
		,	cbiState		:: (Int,Int,Int,Int)	// Its (min,thumb,max,thumbsize) settings
		}

OScreateCompoundControl ::  !OSWindowPtr !(!Int,!Int) !Bool !Bool !(!Int,!Int) !(!Int,!Int)
							!ScrollbarInfo
							!ScrollbarInfo
							!*OSToolbox
						 -> (!OSWindowPtr,!OSWindowPtr,!OSWindowPtr,!*OSToolbox)
OScreateCompoundControl parentWindow parentPos show able (x,y) (w,h)
						hInfo=:{cbiHasScroll=hasHScroll}
						vInfo=:{cbiHasScroll=hasVScroll} tb
	# (x,y)			= (x-fst parentPos,y-snd parentPos)
	  scrollFlags	= (if hasHScroll WS_HSCROLL 0) bitor (if hasVScroll WS_VSCROLL 0)
	  createcci		= {ccMsg=CcRqCREATECOMPOUND,p1=parentWindow,p2=x,p3=y,p4=w,p5=h,p6=scrollFlags}
	# (returncci,tb)= IssueCleanRequest2 osIgnoreCallback createcci tb
	  compoundPtr	= case returncci.ccMsg of
						CcRETURN1	-> returncci.p1
						CcWASQUIT	-> OSNoWindowPtr
						_			-> oswindowCreateError "OScreateCompoundControl"
	# tb			= setScrollRangeAndPos hasHScroll SB_HORZ hInfo.cbiState compoundPtr tb
	# tb			= setScrollRangeAndPos hasVScroll SB_VERT vInfo.cbiState compoundPtr tb
	# tb			= WinSetSelectStateWindow compoundPtr (hasHScroll,hasVScroll) able False tb
	= (compoundPtr,OSNoWindowPtr,OSNoWindowPtr,tb)

setScrollRangeAndPos :: !Bool Int (Int,Int,Int,Int) OSWindowPtr !*OSToolbox -> *OSToolbox
setScrollRangeAndPos hasScroll iBar state wPtr tb
	| not hasScroll
	= tb
	# tb	= WinSetScrollRange     wPtr iBar min max   False tb
	# tb	= WinSetScrollPos       wPtr iBar thumb     False tb
	# tb	= WinSetScrollThumbSize wPtr iBar thumbsize True  tb
	= tb
where
	(min,thumb,max,thumbsize) = state


/*	Window destruction operations.
*/
OSdestroyWindow :: !Bool !OSWindowPtr !*OSToolbox -> (![OSWindowPtr],![OSWindowPtr],!*OSToolbox)
OSdestroyWindow isModal wPtr tb
	# destroycci					= {ccMsg=CcRqDESTROYWINDOW,p1=wPtr,p2=0,p3=0,p4=0,p5=0,p6=0}
	# (_,(activated,deactivated),tb)= IssueCleanRequest osDelayCallback destroycci ([],[]) tb
	= (activated,deactivated,tb)

osDelayCallback :: !CrossCallInfo ([OSWindowPtr],[OSWindowPtr]) !*OSToolbox
			   -> (!CrossCallInfo,([OSWindowPtr],[OSWindowPtr]),!*OSToolbox)
osDelayCallback {ccMsg=CcWmPAINT,p1=wPtr} s tb
	= (Return0Cci,s,OSdelayWindowUpdate wPtr tb)
osDelayCallback {ccMsg=CcWmACTIVATE,p1=wPtr} (activated,deactivated) tb
	= (Return0Cci,([wPtr:activated],deactivated),tb)
osDelayCallback {ccMsg=CcWmDEACTIVATE,p1=wPtr} (activated,deactivated) tb
	= (Return0Cci,(activated,[wPtr:deactivated]),tb)
osDelayCallback {ccMsg} s tb
	| expected
	= (Return0Cci,s,tb)
	= oswindowError "osDelayCallback" ("unexpected delay message "+++toString ccMsg)
where
	expected	= case ccMsg of
					CcWmDRAWCONTROL		-> True
					CcWmGETMINMAXINFO	-> True
					CcWmIDLETIMER		-> True
					CcWmKEYBOARD		-> True
					_					-> False


/*	Control destruction operations.
*/
destroycontrol :: !OSWindowPtr !*OSToolbox -> *OSToolbox
destroycontrol wPtr tb
	# destroycci	= {ccMsg=CcRqDESTROYWINDOW,p1=wPtr,p2=0,p3=0,p4=0,p5=0,p6=0}
	= snd (IssueCleanRequest2 osDestroyControlCallback destroycci tb)
where
	osDestroyControlCallback :: !CrossCallInfo !*OSToolbox -> (!CrossCallInfo,!*OSToolbox)
	osDestroyControlCallback {ccMsg} tb
		| expected
		= (Return0Cci,tb)
		= oswindowError "osDestroyControlCallback" ("unexpected message "+++toString ccMsg)
	where
		expected	= case ccMsg of
						CcWmDRAWCONTROL		-> True
						CcWmBUTTONCLICKED	-> True
						CcWmACTIVATE		-> True
						CcWmIDLETIMER		-> True
						CcWmKEYBOARD		-> True
						CcWmDEACTIVATE		-> True
						_					-> False

OSdestroyRadioControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyRadioControl wPtr tb = destroycontrol wPtr tb

OSdestroyCheckControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyCheckControl wPtr tb = destroycontrol wPtr tb

OSdestroyPopUpControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyPopUpControl wPtr tb = destroycontrol wPtr tb

OSdestroySliderControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroySliderControl wPtr tb = destroycontrol wPtr tb

OSdestroyTextControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyTextControl wPtr tb = destroycontrol wPtr tb

OSdestroyEditControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyEditControl wPtr tb = destroycontrol wPtr tb

OSdestroyButtonControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyButtonControl wPtr tb = destroycontrol wPtr tb

OSdestroyCustomButtonControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyCustomButtonControl wPtr tb = destroycontrol wPtr tb

OSdestroyCustomControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyCustomControl wPtr tb = destroycontrol wPtr tb

OSdestroyCompoundControl :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyCompoundControl wPtr tb = destroycontrol wPtr tb


/*	Control update operations.
*/
OSupdateRadioControl :: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateRadioControl area parentWindow theControl tb = tb

OSupdateCheckControl :: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateCheckControl area parentWindow theControl tb = tb

OSupdatePopUpControl :: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdatePopUpControl area parentWindow theControl tb = tb

OSupdateSliderControl :: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateSliderControl area parentWindow theControl tb = tb

OSupdateTextControl :: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateTextControl area parentWindow theControl tb = tb

OSupdateEditControl :: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateEditControl area parentWindow theControl tb = tb

OSupdateButtonControl :: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateButtonControl area parentWindow theControl tb = tb


/*	Control clipping operations.
*/
oscliprectrgn :: !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
oscliprectrgn (parent_x,parent_y) (left,top, right,bottom) (x,y) (w,h) tb
	# (rgn,tb)	= osnewrgn tb
	= osrectrgn (IntersectRects area item) rgn tb
where
	area		= (left-parent_x,top-parent_y, right-parent_x,bottom-parent_y)
	x`			= x-parent_x
	y`			= y-parent_y
	item		= (x`,y`, x`+w,y`+h)

OSclipRadioControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipRadioControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

OSclipCheckControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipCheckControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

OSclipPopUpControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipPopUpControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

OSclipSliderControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipSliderControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

OSclipTextControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipTextControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

OSclipEditControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipEditControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

OSclipButtonControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipButtonControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

OSclipCustomButtonControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipCustomButtonControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

OSclipCustomControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipCustomControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

OSclipCompoundControl :: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipCompoundControl _ parentPos area itemPos itemSize tb = oscliprectrgn parentPos area itemPos itemSize tb

/*	Window graphics context access operations.
*/
OSgrabWindowPictContext :: !OSWindowPtr !*OSToolbox -> (!OSPictContext,!*OSToolbox)
OSgrabWindowPictContext wPtr tb
	= WinGetDC wPtr tb

OSgrabControlPictContext :: !OSWindowPtr !OSWindowPtr !*OSToolbox -> (!OSPictContext,!*OSToolbox)
OSgrabControlPictContext wPtr cPtr tb
	= WinGetDC cPtr tb

OSreleaseWindowPictContext :: !OSWindowPtr !OSPictContext !*OSToolbox -> *OSToolbox
OSreleaseWindowPictContext wPtr hdc tb
	= WinReleaseDC wPtr (hdc,tb)

OSreleaseControlPictContext :: !OSWindowPtr !OSPictContext !*OSToolbox -> *OSToolbox
OSreleaseControlPictContext cPtr hdc tb
	= WinReleaseDC cPtr (hdc,tb)


/*	Window access operations.
*/
toOSscrollbarRange :: !(!Int,!Int,!Int) !Int -> (!Int,!Int,!Int,!Int)
toOSscrollbarRange (domainMin,viewMin,domainMax) viewSize
	= (osRangeMin,osThumb,osRangeMax,osThumbSize)
where
	(osRangeMin,osRangeMax)	= toOSRange (domainMin,domainMax)
	range					=  domainMax- domainMin
	osRange					= osRangeMax-osRangeMin
	osThumb					= inRange osRangeMin osRange (viewMin-domainMin) range
	osThumbSize				= if (viewSize>=range) osRange (toInt (((toReal viewSize)/(toReal range))*(toReal osRange)))

fromOSscrollbarRange :: !(!Int,!Int) !Int !Int -> Int
fromOSscrollbarRange (domainMin,domainMax) viewSize osThumb
	= inRange domainMin range (osThumb-osRangeMin) osRange
where
	(osRangeMin,osRangeMax)	= toOSRange (domainMin,domainMax)
	range					=  domainMax- domainMin
	osRange					= osRangeMax-osRangeMin

OSscrollbarIsVisible :: !(!Int,!Int) !Int -> Bool
OSscrollbarIsVisible (domainMin,domainMax) viewSize
	= viewSize<domainMax-domainMin

OSscrollbarsAreVisible :: !OSWindowMetrics !(!Int,!Int,!Int,!Int) !(!Int,!Int) !(!Bool,!Bool) -> (!Bool,!Bool)
OSscrollbarsAreVisible {osmHSliderHeight,osmVSliderWidth} (xMin,yMin, xMax,yMax) (width,height) (hasHScroll,hasVScroll)
	= visScrollbars (False,False)
					(hasHScroll && (OSscrollbarIsVisible hRange width),hasVScroll && (OSscrollbarIsVisible vRange height))
where
	hRange	= (xMin,xMax)
	vRange	= (yMin,yMax)
	
	visScrollbars :: !(!Bool,!Bool) !(!Bool,!Bool) -> (!Bool,!Bool)
	visScrollbars (showH1,showV1) (showH2,showV2)
		| showH1==showH2 && showV1==showV2
		= (showH1,showV1)
		= visScrollbars (showH2,showV2) (showH,showV)
	where
		showH	= if showV2 (hasHScroll && OSscrollbarIsVisible hRange (width -osmVSliderWidth )) showH2
		showV	= if showH2 (hasVScroll && OSscrollbarIsVisible vRange (height-osmHSliderHeight)) showV2

toOSRange :: !(!Int,!Int) -> (!Int,!Int)
toOSRange (min,max)
	= (OSSliderMin,if (range<=OSSliderRange) (OSSliderMin+range) OSSliderMax)
where
	range = max-min

inRange :: !Int !Int !Int !Int -> Int
inRange destMin destRange sourceValue sourceRange
	= destMin + (toInt (((toReal sourceValue) / (toReal sourceRange)) * (toReal destRange)))

OSSliderMin		:== 0			// 0
OSSliderMax		:== 32767		// MaxSigned2ByteInt
OSSliderRange	:== 32767		// OSSliderMax-OSSliderMin


OSsetWindowSliderThumb :: !OSWindowPtr !Bool !Int !Bool !*OSToolbox -> *OSToolbox
OSsetWindowSliderThumb theWindow isHorizontal thumb redraw tb
	= WinSetScrollPos theWindow (if isHorizontal SB_HORZ SB_VERT) thumb redraw tb

OSsetWindowSliderThumbSize :: !OSWindowPtr !Bool !Int !Bool !*OSToolbox -> *OSToolbox
OSsetWindowSliderThumbSize theWindow isHorizontal size redraw tb
	= WinSetScrollThumbSize theWindow (if isHorizontal SB_HORZ SB_VERT) size redraw tb

OSsetWindowSlider :: !OSWindowPtr !Bool !(!Int,!Int,!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetWindowSlider theWindow isHorizontal state tb
	= setScrollRangeAndPos True (if isHorizontal SB_HORZ SB_VERT) state theWindow tb

OSinvalidateWindow :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSinvalidateWindow theWindow tb
	= WinInvalidateWindow theWindow tb

OSinvalidateWindowRect :: !OSWindowPtr !Rect !*OSToolbox -> *OSToolbox
OSinvalidateWindowRect theWindow rect tb
	= WinInvalidateRect theWindow rect tb

OSdisableWindow :: !OSWindowPtr !(!Bool,!Bool) !Bool !*OSToolbox -> *OSToolbox
OSdisableWindow theWindow scrollInfo modalContext tb
	= WinSetSelectStateWindow theWindow scrollInfo False modalContext tb

OSenableWindow :: !OSWindowPtr !(!Bool,!Bool) !Bool !*OSToolbox -> *OSToolbox
OSenableWindow theWindow scrollInfo modalContext tb
	= WinSetSelectStateWindow theWindow scrollInfo True modalContext tb

OSactivateWindow :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSactivateWindow thisWindow tb
	= WinRestackWindow thisWindow HWND_TOP tb

OSstackWindow :: !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSstackWindow thisWindow behindWindow tb
	= WinRestackWindow thisWindow behindWindow tb

OShideWindow :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OShideWindow wPtr tb
	# hidecci	= {ccMsg=CcRqSHOWWINDOW,p1=wPtr,p2=toInt False,p3=toInt False,p4=0,p5=0,p6=0}
	= snd (IssueCleanRequest2 osIgnoreCallback hidecci tb)

OSshowWindow :: !OSWindowPtr !Bool !*OSToolbox -> *OSToolbox
OSshowWindow wPtr activate tb
	# showcci	= {ccMsg=CcRqSHOWWINDOW,p1=wPtr,p2=toInt True,p3=toInt activate,p4=0,p5=0,p6=0}
	= snd (IssueCleanRequest2 osIgnoreCallback showcci tb)

OSgetWindowPos :: !OSWindowPtr !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetWindowPos wPtr tb
	= WinGetWindowPos wPtr tb

OSgetWindowSize :: !OSWindowPtr !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetWindowSize wPtr tb
	= WinGetClientSize wPtr tb

OSsetWindowPos :: !OSWindowPtr !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetWindowPos wPtr pos tb
	= WinSetWindowPos wPtr pos tb

OSsetWindowSize	:: !OSWindowPtr !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetWindowSize wPtr size tb
	= WinSetWindowSize wPtr size tb

OSsetWindowTitle :: !OSWindowPtr !String !*OSToolbox -> *OSToolbox
OSsetWindowTitle wPtr title tb
	= WinSetWindowTitle wPtr title tb


/*	Control access operations.
*/
//	On compound controls:
OSinvalidateCompound :: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSinvalidateCompound compoundPtr tb
	= WinInvalidateWindow compoundPtr tb

OSinvalidateCompoundRect :: !OSWindowPtr !Rect !*OSToolbox -> *OSToolbox
OSinvalidateCompoundRect compoundPtr rect tb
	= WinInvalidateRect compoundPtr rect tb

OSsetCompoundSliderThumb :: !OSWindowPtr !Bool !Int !Bool !*OSToolbox -> *OSToolbox
OSsetCompoundSliderThumb compoundPtr isHorizontal thumb redraw tb
	= WinSetScrollPos compoundPtr (if isHorizontal SB_HORZ SB_VERT) thumb redraw tb

OSsetCompoundSliderThumbSize :: !OSWindowPtr !Bool !Int !Bool !*OSToolbox -> *OSToolbox
OSsetCompoundSliderThumbSize compoundPtr isHorizontal size redraw tb
	= WinSetScrollThumbSize compoundPtr (if isHorizontal SB_HORZ SB_VERT) size redraw tb

OSsetCompoundSlider :: !OSWindowPtr !Bool !(!Int,!Int,!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetCompoundSlider compoundPtr isHorizontal state tb
	= setScrollRangeAndPos True (if isHorizontal SB_HORZ SB_VERT) state compoundPtr tb

OSsetCompoundSelect :: !OSWindowPtr !OSWindowPtr !Rect !(!Bool,!Bool) !Bool !*OSToolbox -> *OSToolbox
OSsetCompoundSelect _ compoundPtr _ scrollInfo select tb
	= WinSetSelectStateWindow compoundPtr scrollInfo select False tb
//	= WinEnableControl compoundPtr scrollInfo select tb

OSsetCompoundShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetCompoundShow _ compoundPtr _ show tb
	= WinShowControl compoundPtr show tb

OSsetCompoundPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!Bool,!*OSToolbox)
OSsetCompoundPos _ (parent_x,parent_y) compoundPtr (x,y) _ tb
	= (False,WinSetWindowPos compoundPtr (x-parent_x,y-parent_y) tb)

OSsetCompoundSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetCompoundSize _ _ compoundPtr _ size tb
	= WinSetWindowSize compoundPtr size tb


//	On slider controls:

OSsetSliderThumb :: !OSWindowPtr !OSWindowPtr !Rect !Bool !(!Int,!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetSliderThumb _ cPtr _ redraw (min,thumb,max) tb
	= WinSetScrollPos cPtr SB_CTL thumb redraw tb

OSsetSliderControlSelect :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetSliderControlSelect _ cPtr _ select tb
	= WinEnableControl cPtr select tb

OSsetSliderControlShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetSliderControlShow _ cPtr _ show tb
	= WinShowControl cPtr show tb

OSsetSliderControlPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetSliderControlPos _ (parent_x,parent_y) sliderPtr (x,y) _ tb
	= WinSetWindowPos sliderPtr (x-parent_x,y-parent_y) tb

OSsetSliderControlSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetSliderControlSize _ _ sliderPtr _ size tb
	= WinSetWindowSize sliderPtr size tb


//	On radio controls:

OSsetRadioControl :: !OSWindowPtr !OSWindowPtr !OSWindowPtr !Rect !*OSToolbox -> *OSToolbox
OSsetRadioControl _ current new _ tb
	= WinCheckControl new True (WinCheckControl current False tb)

OSsetRadioControlSelect :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetRadioControlSelect _ cPtr _ select tb
	= WinEnableControl cPtr select tb

OSsetRadioControlShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetRadioControlShow _ cPtr _ show tb
	= WinShowControl cPtr show tb

OSsetRadioControlPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetRadioControlPos _ (parent_x,parent_y) radioPtr (x,y) _ tb
	= WinSetWindowPos radioPtr (x-parent_x,y-parent_y) tb

OSsetRadioControlSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetRadioControlSize _ _ radioPtr _ size tb
	= WinSetWindowSize radioPtr size tb


//	On check controls:

OSsetCheckControl :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetCheckControl _ cPtr _ check tb
	= WinCheckControl cPtr check tb

OSsetCheckControlSelect :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetCheckControlSelect _ cPtr _ select tb
	= WinEnableControl cPtr select tb

OSsetCheckControlShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetCheckControlShow _ cPtr _ show tb
	= WinShowControl cPtr show tb

OSsetCheckControlPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetCheckControlPos _ (parent_x,parent_y) checkPtr (x,y) _ tb
	= WinSetWindowPos checkPtr (x-parent_x,y-parent_y) tb

OSsetCheckControlSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetCheckControlSize _ _ checkPtr _ size tb
	= WinSetWindowSize checkPtr size tb


//	On pop up controls:

OSsetPopUpControl :: !OSWindowPtr !OSWindowPtr !Rect !Rect !Int !Int !String !Bool !*OSToolbox -> *OSToolbox
OSsetPopUpControl _ pPtr _ _ _ new _ _ tb
	= WinSelectPopupItem pPtr (new-1) tb

OSsetPopUpControlSelect :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetPopUpControlSelect _ pPtr _ select tb
	= WinEnableControl pPtr select tb

OSsetPopUpControlShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetPopUpControlShow _ pPtr _ show tb
	= WinShowControl pPtr show tb

OSsetPopUpControlPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetPopUpControlPos _ (parent_x,parent_y) popupPtr (x,y) _ tb
	= WinSetWindowPos popupPtr (x-parent_x,y-parent_y) tb

OSsetPopUpControlSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetPopUpControlSize _ _ popupPtr _ size tb
	= WinSetWindowSize popupPtr size tb


//	On edit controls:

OSsetEditControlText :: !OSWindowPtr !OSWindowPtr !Rect !Rect !Bool !String !*OSToolbox -> *OSToolbox
OSsetEditControlText _ ePtr _ _ _ text tb
	= WinSetWindowTitle ePtr text tb

OSgetEditControlText :: !OSWindowPtr !OSWindowPtr !*OSToolbox -> (!String,!*OSToolbox) 
OSgetEditControlText _ ePtr tb
	= WinGetWindowText ePtr tb

OSsetEditControlCursor :: !OSWindowPtr !OSWindowPtr !Rect !Rect !Int !*OSToolbox -> *OSToolbox
OSsetEditControlCursor _ ePtr _ _ pos tb
	= WinSetEditSelection ePtr pos (pos+1) tb

OSsetEditControlSelect :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetEditControlSelect _ ePtr _ select tb
	= WinEnableControl ePtr select tb

OSsetEditControlShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetEditControlShow _ ePtr _ show tb
	= WinShowControl ePtr show tb

OSsetEditControlPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetEditControlPos _ (parent_x,parent_y) editPtr (x,y) _ tb
	= WinSetWindowPos editPtr (x-parent_x,y-parent_y) tb

OSsetEditControlSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetEditControlSize _ _ editPtr _ size tb
	= WinSetWindowSize editPtr size tb


//	On text controls:

OSsetTextControlText :: !OSWindowPtr !OSWindowPtr !Rect !Rect !Bool !String !*OSToolbox -> *OSToolbox
OSsetTextControlText _ tPtr _ _ _ text tb
	= WinSetWindowTitle tPtr text tb

OSsetTextControlSelect :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetTextControlSelect _ tPtr _ select tb
	= WinEnableControl tPtr select tb

OSsetTextControlShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetTextControlShow _ tPtr _ show tb
	= WinShowControl tPtr show tb

OSsetTextControlPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetTextControlPos _ (parent_x,parent_y) textPtr (x,y) _ tb
	= WinSetWindowPos textPtr (x-parent_x,y-parent_y) tb

OSsetTextControlSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetTextControlSize _ _ textPtr _ size tb
	= WinSetWindowSize textPtr size tb


//	On button controls:

OSsetButtonControlText :: !OSWindowPtr !OSWindowPtr !Rect !String !*OSToolbox -> *OSToolbox
OSsetButtonControlText _ bPtr _ text tb
	= WinSetWindowTitle bPtr text tb

OSsetButtonControlSelect :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetButtonControlSelect _ bPtr _ select tb
	= WinEnableControl bPtr select tb

OSsetButtonControlShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetButtonControlShow _ bPtr _ show tb
	= WinShowControl bPtr show tb

OSsetButtonControlPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetButtonControlPos _ (parent_x,parent_y) buttonPtr (x,y) _ tb
	= WinSetWindowPos buttonPtr (x-parent_x,y-parent_y) tb

OSsetButtonControlSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetButtonControlSize _ _ buttonPtr _ size tb
	= WinSetWindowSize buttonPtr size tb


//	On custom button controls:

OSsetCustomButtonControlSelect :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetCustomButtonControlSelect _ cPtr _ select tb
	= WinEnableControl cPtr select tb

OSsetCustomButtonControlShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetCustomButtonControlShow _ cPtr _ show tb
	= WinShowControl cPtr show tb

OSsetCustomButtonControlPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetCustomButtonControlPos _ (parent_x,parent_y) cPtr (x,y) _ tb
	= WinSetWindowPos cPtr (x-parent_x,y-parent_y) tb

OSsetCustomButtonControlSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetCustomButtonControlSize _ _ cPtr _ size tb
	= WinSetWindowSize cPtr size tb


//	On custom controls:

OSsetCustomControlSelect :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetCustomControlSelect _ cPtr _ select tb
	= WinEnableControl cPtr select tb

OSsetCustomControlShow :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetCustomControlShow _ cPtr _ show tb
	= WinShowControl cPtr show tb

OSsetCustomControlPos :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetCustomControlPos _ (parent_x,parent_y) customPtr (x,y) _ tb
	= WinSetWindowPos customPtr (x-parent_x,y-parent_y) tb

OSsetCustomControlSize :: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetCustomControlSize _ _ customPtr _ size tb
	= WinSetWindowSize customPtr size tb
